(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 12.1' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[     35908,        881]
NotebookOptionsPosition[     32733,        826]
NotebookOutlinePosition[     33161,        844]
CellTagsIndexPosition[     33118,        841]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "HeaderCell",
 ShowCellBracket->False,
 CellMargins->{{0, 0}, {Inherited, 0}},
 Evaluatable->False,
 ImageSize->{350, 24},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 FontWeight->"Bold",ExpressionUUID->"04025938-6eb0-4661-b8fa-fd57a5fccf77"],

Cell[TextData[{
 StyleBox["Concurrence of a 2-Qubit System",
  FontSize->40],
 "\n",
 StyleBox["by", "Author"],
 "\n",
 StyleBox["Mark S. Tame\n", "Section",
  FontFamily->"Arial",
  FontSize->18],
 StyleBox["School of Mathematics and Physics, Queen's University, Belfast.  \
UK.\n", "Author",
  FontFamily->"Arial",
  FontSize->12],
 StyleBox["m.tame@qub.ac.uk", "Text",
  FontFamily->"Arial",
  FontSize->9,
  FontSlant->"Italic"],
 StyleBox["\n", "Author",
  FontFamily->"Arial",
  FontSize->12]
}], "Title",
 FontWeight->"Bold",ExpressionUUID->"f75d00d2-c804-4290-8d18-59caac6f80e1"],

Cell[CellGroupData[{

Cell["Introduction", "Section",ExpressionUUID->"c035c7cc-cc88-460b-8c27-40cb10de6b59"],

Cell[TextData[{
 StyleBox["When analysing quantum systems in Quantum Information Theory it is \
sometimes necessary to compute the amount of entanglement that exists between \
two qubits. For example, suppose Alice and Bob share a pair of entangled \
qubits described by the density matrix ", "Commentary"],
 Cell[BoxData[
  FormBox[
   SubscriptBox["\[Rho]", "AB"], TraditionalForm]],ExpressionUUID->
  "6084bf7f-f04b-4067-a48b-eb9864cfc8f7"],
 StyleBox[". If we would like  to determine the amount of entanglement \
present between the two qubits, then the ", "Commentary"],
 StyleBox["concurrence", "Commentary",
  FontSlant->"Italic"],
 StyleBox[" represents a measure of entanglement that can be used [1]. \n\
However, it becomes quite a task to calculate the concurrence for a \
complicated matrix if we would like to see how the entanglement changes as a \
particular parameter ", "Commentary"],
 Cell[BoxData[
  FormBox["\[Alpha]", TraditionalForm]],ExpressionUUID->
  "3f2c801d-d9fd-49e5-a953-d022ff012abc"],
 StyleBox[" is varied. For example, this parameter could describe \
imperfections in the ideal case, such as decoherence acting on the system ", 
  "Commentary"],
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["\[Rho]", "AB"], ":", " ", 
    RowBox[{
     SubscriptBox["\[Rho]", "AB"], "(", "\[Alpha]", ")"}]}], 
   TraditionalForm]],ExpressionUUID->"3ec7f69c-0097-4a85-8ad3-4a5e53ed7a05"],
 StyleBox[", with the density matrix losing purity as ", "Commentary"],
 Cell[BoxData[
  FormBox["\[Alpha]", TraditionalForm]],ExpressionUUID->
  "ef6f39d7-918a-440d-83a9-7106bc0e6cb0"],
 StyleBox[" increases. Calculating the concurrence by hand in this case \
becomes unmanageable. What the ", "Commentary"],
 StyleBox["Concurrence", "InlineInput"],
 StyleBox["  function does, is allow you to do this by letting ", 
  "Commentary"],
 StyleBox["Mathematica", "Commentary",
  FontSlant->"Italic"],
 StyleBox[" do the work for you:\n", "Commentary"],
 StyleBox["Concurrence[", "InlineInput"],
 Cell[BoxData[
  FormBox[
   SubscriptBox["\[Rho]", "AB"], TraditionalForm]],ExpressionUUID->
  "a344e279-f52e-4fa5-a723-2af1730d88d4"],
 StyleBox[",", "InlineInput"],
 "\[Alpha]",
 StyleBox[",", "InlineInput"],
 Cell[BoxData[
  FormBox[
   SubscriptBox["\[Alpha]", "min"], TraditionalForm]],ExpressionUUID->
  "136e9b2d-b20d-4daa-9fb4-2eff2c3e93dc"],
 StyleBox[",", "InlineInput"],
 Cell[BoxData[
  FormBox[
   SubscriptBox["\[Alpha]", "max"], TraditionalForm]],ExpressionUUID->
  "3b726fd2-4ed7-46bb-ba38-c98c56381cbd"],
 StyleBox[",", "InlineInput"],
 Cell[BoxData[
  FormBox[
   SubscriptBox["\[Alpha]", "points"], TraditionalForm]],ExpressionUUID->
  "5265a0f0-68d2-4a1c-8e5e-d5c3fe5b0f7a"],
 StyleBox["]", "InlineInput"],
 StyleBox[".", "Commentary"],
 "\n",
 StyleBox["To use the function, you must evaluate it first in ", "Commentary"],
 StyleBox["The Code", "Subtitle",
  FontSize->12,
  FontSlant->"Plain",
  FontColor->RGBColor[0.500008, 0, 0.500008]],
 StyleBox[" section. Then it is straightforward to use, see the ", 
  "Commentary"],
 StyleBox["Example", "Subtitle",
  FontSize->12,
  FontSlant->"Plain",
  FontColor->RGBColor[0.500008, 0, 0.500008]],
 StyleBox[" section for its possible use. \nIf you would like to know more \
about the theory behind the concurrence measure of entanglement, see [1, 2]. \
", "Commentary"]
}], "Text",
 TextJustification->1,
 FontWeight->"Bold",ExpressionUUID->"02aa7110-5fb8-41fe-8afb-77a989dfab52"]
}, Open  ]],

Cell[CellGroupData[{

Cell["The Code", "Section",ExpressionUUID->"5159ce02-54c7-47b6-bdff-02dd804d03c9"],

Cell[TextData[{
 StyleBox["Here is the code for the ", "Commentary"],
 StyleBox["Concurrence", "InlineInput"],
 StyleBox["  function to calculate the amount of entanglement between 2 \
qubits as a parameter ", "Commentary"],
 Cell[BoxData[
  FormBox["\[Alpha]", TraditionalForm]],ExpressionUUID->
  "f8afd186-8bee-4ace-ae05-80d0b65050b6"],
 StyleBox[" is varied. Evaluate the cell below and you can use it. For more \
help, please see the ", "Commentary"],
 StyleBox["Examples", "Subtitle",
  FontSize->12,
  FontSlant->"Plain",
  FontColor->RGBColor[0.500008, 0, 0.500008]],
 StyleBox[" section:", "Commentary"]
}], "Text",
 FontWeight->"Bold",ExpressionUUID->"59d855be-0c40-4ba9-b4d2-21c21acef7c5"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Concurrence", "[", 
   RowBox[{
    RowBox[{"c_List", "?", "MatrixQ"}], ",", "\[Alpha]_", ",", "\[Alpha]min_",
     ",", "\[Alpha]max_", ",", "d\[Alpha]_"}], "]"}], " ", ":=", " ", 
  RowBox[{"(", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"sigy", "=", 
      RowBox[{"(", GridBox[{
         {"0", 
          RowBox[{"-", "\[ImaginaryI]"}]},
         {"\[ImaginaryI]", "0"}
        }], ")"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"sigsigy", "=", 
      RowBox[{"KroneckerProduct", "[", 
       RowBox[{"sigy", ",", "sigy"}], "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"rhototal", "=", "c"}], ";", "\[IndentingNewLine]", 
     RowBox[{"\[Alpha]", "=", "\[CapitalGamma]"}], ";", "\[IndentingNewLine]", 
     RowBox[{"rhototal2", "=", 
      RowBox[{"sigsigy", ".", 
       RowBox[{"(", 
        RowBox[{"Conjugate", "[", "c", "]"}], ")"}], ".", "sigsigy"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"Tabconc", "=", 
      RowBox[{"Range", "[", 
       RowBox[{"d\[Alpha]", "+", "1"}], "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"For", "[", 
      RowBox[{
       RowBox[{"w", "=", "0"}], ",", 
       RowBox[{"w", "<", 
        RowBox[{"d\[Alpha]", "+", "1"}]}], ",", 
       RowBox[{
        RowBox[{"w", "++"}], ";", "\[IndentingNewLine]", 
        RowBox[{"\[CapitalGamma]", "=", 
         RowBox[{"N", "[", 
          RowBox[{"\[Alpha]min", "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "/", "d\[Alpha]"}], ")"}], 
            RowBox[{"(", 
             RowBox[{"w", "-", "1"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{"\[Alpha]max", "-", "\[Alpha]min"}], ")"}]}]}], "]"}]}], 
        ";", "\[IndentingNewLine]", 
        RowBox[{"Print", "[", 
         RowBox[{"Eigenvalues", "[", 
          RowBox[{"rhototal", ".", "rhototal2"}], "]"}], "]"}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"g", "=", 
         RowBox[{"Length", "[", 
          RowBox[{"Eigenvalues", "[", 
           RowBox[{"rhototal", ".", "rhototal2"}], "]"}], "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"Conc", "=", 
         RowBox[{
          SqrtBox[
           RowBox[{"Chop", "[", 
            RowBox[{
             RowBox[{"Eigenvalues", "[", 
              RowBox[{"rhototal", ".", "rhototal2"}], "]"}], "[", 
             RowBox[{"[", "1", "]"}], "]"}], "]"}]], "-", 
          RowBox[{
           UnderoverscriptBox["\[Sum]", 
            RowBox[{"i", "=", "2"}], "g"], 
           SqrtBox[
            RowBox[{"(", 
             RowBox[{"Chop", "[", 
              RowBox[{
               RowBox[{"Eigenvalues", "[", 
                RowBox[{"rhototal", ".", "rhototal2"}], "]"}], "[", 
               RowBox[{"[", "i", "]"}], "]"}], "]"}], ")"}]]}]}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"Tabconc", "[", 
          RowBox[{"[", "w", "]"}], "]"}], "=", 
         RowBox[{"{", 
          RowBox[{"\[CapitalGamma]", ",", "Conc"}], "}"}]}], ";"}]}], 
      "\[IndentingNewLine]", "]"}], ";", "\[IndentingNewLine]", 
     RowBox[{"Print", "[", "Tabconc", "]"}], ";", "\[IndentingNewLine]", 
     RowBox[{"\[CapitalGamma]", "=."}], ";", "\[IndentingNewLine]", 
     RowBox[{"\[Alpha]", "=."}], ";"}], "\[IndentingNewLine]", ";", 
    RowBox[{"Return", "[", 
     RowBox[{"ListPlot", "[", 
      RowBox[{"Tabconc", ",", " ", 
       RowBox[{"PlotRange", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"\[Alpha]min", ",", "\[Alpha]max"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"0", ",", "1"}], "}"}]}], "}"}]}], ",", " ", 
       RowBox[{"Joined", "\[Rule]", " ", "True"}], ",", " ", 
       RowBox[{"Frame", "\[Rule]", " ", "True"}], ",", " ", 
       RowBox[{"FrameLabel", "\[Rule]", " ", 
        RowBox[{"{", 
         RowBox[{"\"\<\[Alpha]\>\"", ",", "\"\<Concurrence\>\""}], "}"}]}], 
       ",", 
       RowBox[{"PlotStyle", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"FontSize", "\[Rule]", "14"}], "}"}]}]}], "]"}], "]"}]}], 
   ")"}]}]], "Input",
 CellChangeTimes->{{3.8066626683974457`*^9, 3.806662678050861*^9}, {
  3.806662738169835*^9, 3.806662746447033*^9}},
 CellLabel->"In[1]:=",ExpressionUUID->"f960cdf3-f15b-4247-8670-4d49f4b14723"]
}, Closed]],

Cell[CellGroupData[{

Cell["Example", "Section",ExpressionUUID->"47f677d5-1097-43bc-afbf-d16b79ec3460"],

Cell[TextData[{
 StyleBox["Here is an example of how it works. ", "Commentary"],
 StyleBox["Concurrence", "InlineInput"],
 StyleBox[" has 5 arguments, the density matrix ", "Commentary"],
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["\[Rho]", "AB"], "(", "\[Alpha]", ")"}], TraditionalForm]],
  ExpressionUUID->"12fdcb9f-d024-4377-8002-da515e53e5f9"],
 StyleBox[", the parameter that is being varied ", "Commentary"],
 Cell[BoxData[
  FormBox["\[Alpha]", TraditionalForm]],ExpressionUUID->
  "ba69be7c-90da-47ef-958f-21fa8a353e50"],
 StyleBox[", the minimum and maximum values of ", "Commentary"],
 Cell[BoxData[
  FormBox["\[Alpha]", TraditionalForm]],ExpressionUUID->
  "c66b7743-cc84-43d1-891f-834a39d7ce42"],
 StyleBox[" given by ", "Commentary"],
 Cell[BoxData[
  FormBox[
   SubscriptBox["\[Alpha]", "min"], TraditionalForm]],ExpressionUUID->
  "ee61f13d-0ddb-4529-aa7a-0ead82517bba"],
 StyleBox["and ", "Commentary"],
 Cell[BoxData[
  FormBox[
   SubscriptBox["\[Alpha]", "max"], TraditionalForm]],ExpressionUUID->
  "57194812-723c-495a-a7d8-0fa1d15214df"],
 " ",
 StyleBox["respectively and the number of points you would like ", 
  "Commentary"],
 Cell[BoxData[
  FormBox[
   SubscriptBox["\[Alpha]", "points"], TraditionalForm]],ExpressionUUID->
  "526dd303-3447-48b1-9ef6-72f01760575b"],
 StyleBox[" (the resolution of your data).\n", "Commentary"],
 StyleBox["- Example 1.", "Commentary",
  FontSize->12],
 StyleBox["\nIn this example we have a density matrix describing the \
maximally entangled state: ", "Commentary"],
 Cell[BoxData[
  FormBox[
   RowBox[{
    FractionBox["1", 
     SqrtBox["2"]], 
    SubscriptBox[
     RowBox[{"(", 
      RowBox[{"|", 
       RowBox[{"00", ">", "+"}], "|", 
       RowBox[{"11", ">"}]}], ")"}], "AB"]}], TraditionalForm]],
  ExpressionUUID->"03949912-2f57-439c-bc5e-040f864e990c"],
 " ",
 StyleBox["undergoing what is known as a  ", "Commentary"],
 StyleBox["depolarizing channel", "Commentary",
  FontSlant->"Italic"],
 StyleBox[":", "Commentary"]
}], "Text",
 TextJustification->1,
 FontWeight->"Bold",ExpressionUUID->"682415c4-1f59-4dcf-af14-0ba95f94b174"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   SubscriptBox["\[Rho]", "AB"], "=", 
   RowBox[{
    FractionBox["1", "2"], 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"1", ",", "0", ",", "0", ",", "1"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"1", ",", "0", ",", "0", ",", "1"}], "}"}]}], "}"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  SubscriptBox["\[Rho]", "AB"], " ", "//", 
  "MatrixForm"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   SubscriptBox["ThroughChannel\[Rho]", "AB"], "=", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"1", "-", "\[Alpha]"}], ")"}], 
     SubscriptBox["\[Rho]", "AB"]}], "+", 
    RowBox[{"\[Alpha]", " ", 
     RowBox[{"(", 
      RowBox[{"1", "/", "4"}], ")"}], 
     RowBox[{"IdentityMatrix", "[", "4", "]"}]}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  SubscriptBox["ThroughChannel\[Rho]", "AB"], " ", "//", 
  "MatrixForm"}], "\[IndentingNewLine]", 
 RowBox[{"Concurrence", "[", 
  RowBox[{
   SubscriptBox["ThroughChannel\[Rho]", "AB"], ",", " ", "\[Alpha]", ",", "0",
    ",", "1", ",", "10"}], "]"}]}], "Input",
 CellGroupingRules->"OutputGrouping",
 CellLabel->"In[2]:=",ExpressionUUID->"c0b49340-ee08-4514-8e54-e9a05360c07c"],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {
      FractionBox["1", "2"], "0", "0", 
      FractionBox["1", "2"]},
     {"0", "0", "0", "0"},
     {"0", "0", "0", "0"},
     {
      FractionBox["1", "2"], "0", "0", 
      FractionBox["1", "2"]}
    },
    GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 CellChangeTimes->{3.806662245344193*^9, 3.806662718006531*^9, 
  3.806662752251416*^9, 3.806805612948711*^9},
 CellLabel->
  "Out[3]//MatrixForm=",ExpressionUUID->"665409c4-d1d5-489b-828a-\
28e378389cef"],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {
      RowBox[{
       FractionBox[
        RowBox[{"1", "-", "\[Alpha]"}], "2"], "+", 
       FractionBox["\[Alpha]", "4"]}], "0", "0", 
      FractionBox[
       RowBox[{"1", "-", "\[Alpha]"}], "2"]},
     {"0", 
      FractionBox["\[Alpha]", "4"], "0", "0"},
     {"0", "0", 
      FractionBox["\[Alpha]", "4"], "0"},
     {
      FractionBox[
       RowBox[{"1", "-", "\[Alpha]"}], "2"], "0", "0", 
      RowBox[{
       FractionBox[
        RowBox[{"1", "-", "\[Alpha]"}], "2"], "+", 
       FractionBox["\[Alpha]", "4"]}]}
    },
    GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 CellChangeTimes->{3.806662245344193*^9, 3.806662718006531*^9, 
  3.806662752251416*^9, 3.806805612956024*^9},
 CellLabel->
  "Out[5]//MatrixForm=",ExpressionUUID->"ede69659-45f4-4a52-a3f8-\
02cb11664470"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1.`", ",", "0.`", ",", "0.`", ",", "0.`"}], "}"}]], "Print",
 CellChangeTimes->{3.806662245359529*^9, 3.806662718057188*^9, 
  3.806662752260695*^9, 3.806805612995792*^9},
 CellLabel->
  "During evaluation of \
In[2]:=",ExpressionUUID->"70b1173b-8f06-46f7-beb7-49c8c1a4783c"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "0.8556250000000001`", ",", "0.0006250000000000001`", ",", 
   "0.0006249999999999867`", ",", "0.0006249999999999867`"}], "}"}]], "Print",\

 CellChangeTimes->{3.806662245359529*^9, 3.806662718057188*^9, 
  3.806662752260695*^9, 3.806805613001706*^9},
 CellLabel->
  "During evaluation of \
In[2]:=",ExpressionUUID->"b10d5a51-4ad6-43e7-b57b-4f8fa9e2f22a"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "0.7225`", ",", "0.00250000000000005`", ",", "0.0025000000000000005`", ",", 
   "0.0024999999999998834`"}], "}"}]], "Print",
 CellChangeTimes->{3.806662245359529*^9, 3.806662718057188*^9, 
  3.806662752260695*^9, 3.8068056130074453`*^9},
 CellLabel->
  "During evaluation of \
In[2]:=",ExpressionUUID->"1e0fe4d2-9ee5-47eb-b9ab-43d56596a31f"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "0.600625`", ",", "0.005625`", ",", "0.005624999999999991`", ",", 
   "0.005624999999999991`"}], "}"}]], "Print",
 CellChangeTimes->{3.806662245359529*^9, 3.806662718057188*^9, 
  3.806662752260695*^9, 3.806805613010683*^9},
 CellLabel->
  "During evaluation of \
In[2]:=",ExpressionUUID->"a1d1d04b-6f3a-43d6-aa04-dddcd201fb26"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "0.49`", ",", "0.010000000000000009`", ",", "0.010000000000000009`", ",", 
   "0.010000000000000002`"}], "}"}]], "Print",
 CellChangeTimes->{3.806662245359529*^9, 3.806662718057188*^9, 
  3.806662752260695*^9, 3.806805613014141*^9},
 CellLabel->
  "During evaluation of \
In[2]:=",ExpressionUUID->"de13004f-942b-48ec-8d1e-97e9c7f43c71"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.390625`", ",", "0.015625`", ",", "0.015625`", ",", "0.015625`"}],
   "}"}]], "Print",
 CellChangeTimes->{3.806662245359529*^9, 3.806662718057188*^9, 
  3.806662752260695*^9, 3.8068056130162086`*^9},
 CellLabel->
  "During evaluation of \
In[2]:=",ExpressionUUID->"55c9ec3f-9f9d-41c7-880f-28df9f704b2e"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "0.3025`", ",", "0.0225`", ",", "0.022499999999999996`", ",", 
   "0.022499999999999975`"}], "}"}]], "Print",
 CellChangeTimes->{3.806662245359529*^9, 3.806662718057188*^9, 
  3.806662752260695*^9, 3.8068056130180492`*^9},
 CellLabel->
  "During evaluation of \
In[2]:=",ExpressionUUID->"2639916d-b4fb-4ad0-8dc9-d14462c05e1c"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "0.22562500000000002`", ",", "0.030625000000000017`", ",", "0.030625`", ",",
    "0.03062499999999993`"}], "}"}]], "Print",
 CellChangeTimes->{3.806662245359529*^9, 3.806662718057188*^9, 
  3.806662752260695*^9, 3.806805613021299*^9},
 CellLabel->
  "During evaluation of \
In[2]:=",ExpressionUUID->"51d9aa4f-2a17-44e8-90ce-cec22eccc05b"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "0.15999999999999998`", ",", "0.04000000000000003`", ",", 
   "0.04000000000000001`", ",", "0.04000000000000001`"}], "}"}]], "Print",
 CellChangeTimes->{3.806662245359529*^9, 3.806662718057188*^9, 
  3.806662752260695*^9, 3.806805613024384*^9},
 CellLabel->
  "During evaluation of \
In[2]:=",ExpressionUUID->"4bce6549-ee31-4016-90ef-523723ff4004"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "0.10562500000000002`", ",", "0.05062500000000003`", ",", 
   "0.05062500000000001`", ",", "0.050625`"}], "}"}]], "Print",
 CellChangeTimes->{3.806662245359529*^9, 3.806662718057188*^9, 
  3.806662752260695*^9, 3.806805613025948*^9},
 CellLabel->
  "During evaluation of \
In[2]:=",ExpressionUUID->"a7eb8c23-9902-4a00-ac33-2dba93c06ea7"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.0625`", ",", "0.0625`", ",", "0.0625`", ",", "0.0625`"}], 
  "}"}]], "Print",
 CellChangeTimes->{3.806662245359529*^9, 3.806662718057188*^9, 
  3.806662752260695*^9, 3.806805613028551*^9},
 CellLabel->
  "During evaluation of \
In[2]:=",ExpressionUUID->"a7f4f4bd-e8fe-4666-8cd4-457c50f93cc2"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0.`", ",", "1.`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.1`", ",", "0.8500000000000005`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.2`", ",", "0.7000000000000006`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.3`", ",", "0.5500000000000002`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.4`", ",", "0.39999999999999986`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.5`", ",", "0.25`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.6`", ",", "0.10000000000000014`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.7`", ",", 
     RowBox[{"-", "0.04999999999999977`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.8`", ",", 
     RowBox[{"-", "0.20000000000000012`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.9`", ",", 
     RowBox[{"-", "0.35000000000000003`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.`", ",", 
     RowBox[{"-", "0.5`"}]}], "}"}]}], "}"}]], "Print",
 CellChangeTimes->{3.806662245359529*^9, 3.806662718057188*^9, 
  3.806662752260695*^9, 3.806805613031571*^9},
 CellLabel->
  "During evaluation of \
In[2]:=",ExpressionUUID->"ceda51d4-89ea-459d-9e6d-925e381d7ea1"]
}, Open  ]],

Cell[BoxData[
 GraphicsBox[{{}, {{{}, {}, 
     {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
      0.012833333333333334`], AbsoluteThickness[1.6], 
      StyleBox[
       LineBox[{{0., 1.}, {0.1, 0.8500000000000005}, {0.2, 
        0.7000000000000006}, {0.3, 0.5500000000000002}, {0.4, 
        0.39999999999999986`}, {0.5, 0.25}, {0.6, 0.10000000000000014`}, {
        0.6666666666666667, 0.}}],
       FontSize->14]}}, 
    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.012833333333333334`],
      AbsoluteThickness[1.6], 
     StyleBox[{},
      FontSize->14]}, {
     {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
      0.012833333333333334`], AbsoluteThickness[1.6], 
      StyleBox[{},
       FontSize->14]}, {}}, {
     {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
      0.012833333333333334`], AbsoluteThickness[1.6], 
      StyleBox[{},
       FontSize->14]}, {}}}, {{}, {}}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0, 0},
  DisplayFunction->Identity,
  Frame->{{True, True}, {True, True}},
  FrameLabel->{{
     FormBox["\"Concurrence\"", TraditionalForm], None}, {
     FormBox["\"\[Alpha]\"", TraditionalForm], None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  Method->{
   "OptimizePlotMarkers" -> True, "OptimizePlotMarkers" -> True, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        Identity[
         Part[#, 1]], 
        Identity[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        Identity[
         Part[#, 1]], 
        Identity[
         Part[#, 2]]}& )}},
  PlotRange->{{0, 1}, {0, 1}},
  PlotRangeClipping->True,
  PlotRangePadding->{{0, 0}, {0, 0}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{3.806662245344193*^9, 3.806662718006531*^9, 
  3.806662752251416*^9, 3.8068056135549393`*^9},
 CellLabel->"Out[6]=",ExpressionUUID->"7df16c20-868d-4b17-be87-7d9287cabe7f"],

Cell[TextData[StyleBox["This provides us with the behaviour of the amount of \
entanglement present (in terms of the concurrence) between the two qubits as \
they experience decoherence induced from a noisy environment (depolarizing \
channel).", "Commentary"]], "Text",
 CellChangeTimes->{{3.8066627771002607`*^9, 3.806662777593961*^9}},
 TextJustification->1,
 FontWeight->"Bold",ExpressionUUID->"87a6f435-7132-4498-9787-8fc48a518a08"]
}, Closed]],

Cell[CellGroupData[{

Cell["References", "Section",ExpressionUUID->"5874e10b-5c8a-49b9-80a3-595922b46db5"],

Cell[TextData[{
 StyleBox["[1] W. K. Wooters, ", "Commentary"],
 StyleBox["Phys. Rev. Lett.", "Commentary",
  FontSlant->"Italic"],
 StyleBox[" ", "Commentary"],
 StyleBox["80", "Commentary",
  FontWeight->"Plain",
  FontVariations->{"CompatibilityType"->0}],
 StyleBox[", 2245 (1998).\n[2] F. Mintert, A. R. R. Carvalho, M. Ku", 
  "Commentary"],
 Cell[BoxData[
  FormBox[
   StyleBox[
    OverscriptBox["s", "'"], "Commentary"], TraditionalForm]],ExpressionUUID->
  "2cf84bae-e6ff-4d40-b846-4404f4119354"],
 StyleBox[" and A. Buchleitner, ", "Commentary"],
 StyleBox["Phys. Rep. ", "Commentary",
  FontSlant->"Italic"],
 StyleBox["415, 207 (2005).", "Commentary"]
}], "Text",
 TextJustification->1,
 FontWeight->"Bold",ExpressionUUID->"bfef0031-0f9d-4097-a004-219f8c8c6794"]
}, Closed]]
},
WindowToolbars->{},
WindowSize->{838, 728},
WindowMargins->{{Automatic, 38}, {Automatic, 0}},
Magnification->1,
FrontEndVersion->"12.1 for Mac OS X x86 (64-bit) (March 18, 2020)",
StyleDefinitions->"Demo.nb",
ExpressionUUID->"4f5e09c7-e961-4e18-a342-ca62b4824ad1"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[558, 20, 8467, 142, 24, "HeaderCell",ExpressionUUID->"04025938-6eb0-4661-b8fa-fd57a5fccf77",
 Evaluatable->False],
Cell[9028, 164, 587, 21, 169, "Title",ExpressionUUID->"f75d00d2-c804-4290-8d18-59caac6f80e1"],
Cell[CellGroupData[{
Cell[9640, 189, 86, 0, 71, "Section",ExpressionUUID->"c035c7cc-cc88-460b-8c27-40cb10de6b59"],
Cell[9729, 191, 3459, 83, 219, "Text",ExpressionUUID->"02aa7110-5fb8-41fe-8afb-77a989dfab52"]
}, Open  ]],
Cell[CellGroupData[{
Cell[13225, 279, 82, 0, 71, "Section",ExpressionUUID->"5159ce02-54c7-47b6-bdff-02dd804d03c9"],
Cell[13310, 281, 700, 16, 46, "Text",ExpressionUUID->"59d855be-0c40-4ba9-b4d2-21c21acef7c5"],
Cell[14013, 299, 4307, 105, 529, "Input",ExpressionUUID->"f960cdf3-f15b-4247-8670-4d49f4b14723"]
}, Closed]],
Cell[CellGroupData[{
Cell[18357, 409, 81, 0, 40, "Section",ExpressionUUID->"47f677d5-1097-43bc-afbf-d16b79ec3460"],
Cell[18441, 411, 2122, 57, 121, "Text",ExpressionUUID->"682415c4-1f59-4dcf-af14-0ba95f94b174"],
Cell[20566, 470, 1397, 41, 129, "Input",ExpressionUUID->"c0b49340-ee08-4514-8e54-e9a05360c07c",
 CellGroupingRules->"OutputGrouping"],
Cell[21966, 513, 862, 26, 124, "Output",ExpressionUUID->"665409c4-d1d5-489b-828a-28e378389cef"],
Cell[22831, 541, 1190, 36, 136, "Output",ExpressionUUID->"ede69659-45f4-4a52-a3f8-02cb11664470"],
Cell[CellGroupData[{
Cell[24046, 581, 315, 7, 24, "Print",ExpressionUUID->"70b1173b-8f06-46f7-beb7-49c8c1a4783c"],
Cell[24364, 590, 397, 10, 24, "Print",ExpressionUUID->"b10d5a51-4ad6-43e7-b57b-4f8fa9e2f22a"],
Cell[24764, 602, 383, 9, 24, "Print",ExpressionUUID->"1e0fe4d2-9ee5-47eb-b9ab-43d56596a31f"],
Cell[25150, 613, 370, 9, 24, "Print",ExpressionUUID->"a1d1d04b-6f3a-43d6-aa04-dddcd201fb26"],
Cell[25523, 624, 378, 9, 24, "Print",ExpressionUUID->"de13004f-942b-48ec-8d1e-97e9c7f43c71"],
Cell[25904, 635, 344, 8, 24, "Print",ExpressionUUID->"55c9ec3f-9f9d-41c7-880f-28df9f704b2e"],
Cell[26251, 645, 368, 9, 24, "Print",ExpressionUUID->"2639916d-b4fb-4ad0-8dc9-d14462c05e1c"],
Cell[26622, 656, 380, 9, 24, "Print",ExpressionUUID->"51d9aa4f-2a17-44e8-90ce-cec22eccc05b"],
Cell[27005, 667, 390, 9, 24, "Print",ExpressionUUID->"4bce6549-ee31-4016-90ef-523723ff4004"],
Cell[27398, 678, 379, 9, 24, "Print",ExpressionUUID->"a7eb8c23-9902-4a00-ac33-2dba93c06ea7"],
Cell[27780, 689, 334, 8, 24, "Print",ExpressionUUID->"a7f4f4bd-e8fe-4666-8cd4-457c50f93cc2"],
Cell[28117, 699, 1189, 33, 44, "Print",ExpressionUUID->"ceda51d4-89ea-459d-9e6d-925e381d7ea1"]
}, Open  ]],
Cell[29321, 735, 2056, 52, 269, "Output",ExpressionUUID->"7df16c20-868d-4b17-be87-7d9287cabe7f"],
Cell[31380, 789, 437, 6, 39, "Text",ExpressionUUID->"87a6f435-7132-4498-9787-8fc48a518a08"]
}, Closed]],
Cell[CellGroupData[{
Cell[31854, 800, 84, 0, 40, "Section",ExpressionUUID->"5874e10b-5c8a-49b9-80a3-595922b46db5"],
Cell[31941, 802, 776, 21, 56, "Text",ExpressionUUID->"bfef0031-0f9d-4097-a004-219f8c8c6794"]
}, Closed]]
}
]
*)

